/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.globalsetting.service.impl;

import com.tp_link.eap.d.b;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eapsetting.SsidC;
import com.tp_link.eap.domain.eapsetting.SsidConfig;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.globalsetting.WlanGroup;
import com.tp_link.eap.domain.portal.Guest;
import com.tp_link.eap.monitor.globalsetting.model.WlanGroupModel;
import com.tp_link.eap.monitor.globalsetting.repo.WlanGroupRepository;
import com.tp_link.eap.monitor.globalsetting.service.g;
import com.tp_link.eap.monitor.globalsetting.service.l;
import com.tp_link.eap.monitor.globalsetting.service.n;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.k.a;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.validation.Validator;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="wlanGroupService")
public class WlanGroupService
implements n {
    private static final Logger a = LoggerFactory.getLogger(WlanGroupService.class);
    @Autowired
    private WlanGroupRepository b;
    @Autowired
    private l c;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b d;
    @Autowired
    private g e;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a f;
    @Autowired
    private MongoTemplate g;
    @Autowired
    private com.tp_link.eap.monitor.site.service.a h;
    @Autowired
    private Validator validator;

    @Override
    public List<WlanGroup> getAll() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.b.findAll());
    }

    @Override
    public List<WlanGroup> getBySiteAndRadioId(Integer radioId) {
        if (null == radioId) {
            return null;
        }
        String string = com.tp_link.eap.d.b.a();
        if (string == null) {
            return null;
        }
        return this.b.findBySiteAndRadioIdOrderByIdAsc(string, radioId);
    }

    @Override
    public OperationResponse getWlanGroupList(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("band");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            hashMap.put("data", this.getAllBySite());
        } else {
            Integer n2 = string.equalsIgnoreCase("2.4GHZ") ? 0 : 1;
            hashMap.put("data", this.getBySiteAndRadioId(n2));
        }
        hashMap.put("maxWlanGroups", 500);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public WlanGroup getWlanGroup(String wlanId) {
        if (null == wlanId) {
            return null;
        }
        return this.b.findByWlanId(wlanId);
    }

    @Override
    public WlanGroup getDefWlanByRadioId(Integer radioId) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"site").is((Object)com.tp_link.eap.d.b.a()));
        query.addCriteria(Criteria.where((String)"radioId").is((Object)radioId));
        query.addCriteria(Criteria.where((String)"isDefault").is((Object)true));
        WlanGroup wlanGroup = (WlanGroup)this.g.findOne(query, WlanGroup.class);
        if (wlanGroup == null) {
            a.info("Failed to get default wlan group for site : " + com.tp_link.eap.d.b.a());
            wlanGroup = new WlanGroup();
            wlanGroup.setIsDefault(Boolean.valueOf(true));
            wlanGroup.setSite(com.tp_link.eap.d.b.a());
            wlanGroup.setMaxSsids(com.tp_link.eap.util.e.bA);
            wlanGroup.setName("Default");
            wlanGroup.setRadioId(radioId);
            this.saveWlanGroup(wlanGroup, false);
        }
        return wlanGroup;
    }

    private boolean a(String string) {
        if (string == null) {
            return false;
        }
        return this.b.findByWlanId(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse saveWlanGroup(WlanGroup wlanGroup, boolean needLimit) {
        if (null == wlanGroup) {
            a.warn("Invalid request parameter.");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.r);
        }
        HashMap<String, String> hashMap = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (hashMap) {
            if (!this.h.siteNameAlreadyExist(string)) {
                a.warn("Invalid sitName.");
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            WlanGroup wlanGroup2 = this.b.findBySiteAndRadioIdAndName(com.tp_link.eap.d.b.a(), wlanGroup.getRadioId(), wlanGroup.getName());
            if (wlanGroup2 != null && !wlanGroup2.getWlanId().equals(wlanGroup.getWlanId())) {
                a.warn("WLAN Group already existed.");
                OperationResponse operationResponse = new OperationResponse(ResErrorCode.u);
                operationResponse.setMsg(String.format("WLAN Group %S already existed.", wlanGroup.getName()));
                return operationResponse;
            }
            if (com.tp_link.eap.util.a.e.a((String)wlanGroup.getWlanId())) {
                String string2;
                if (needLimit && this.b.countByRadioId(wlanGroup.getRadioId()) >= 500L) {
                    a.warn("The number of WLAN groups for this band has reached the limit.");
                    return new OperationResponse(ResErrorCode.v);
                }
                wlanGroup.setSite(com.tp_link.eap.d.b.a());
                wlanGroup.setMaxSsids(Integer.valueOf(8));
                while (this.a(string2 = com.tp_link.eap.util.k.a.a())) {
                }
                wlanGroup.setWlanId(string2);
                this.b.save(wlanGroup);
            } else {
                WlanGroup wlanGroup3 = this.b.findByWlanId(wlanGroup.getWlanId());
                if (wlanGroup3 == null) {
                    a.warn("Invalid request parameter.");
                    return com.tp_link.eap.util.e.aZ;
                }
                if (wlanGroup3.getIsDefault() != null && wlanGroup3.getIsDefault().booleanValue()) {
                    a.warn("Default wlan group can't be edited.");
                    return new OperationResponse(ResErrorCode.w);
                }
                wlanGroup3.setName(wlanGroup.getName());
                this.b.save(wlanGroup3);
                this.a(wlanGroup3.getWlanId(), wlanGroup3.getName());
                this.a(wlanGroup3.getWlanId(), wlanGroup3.getName(), wlanGroup3.getRadioId());
            }
        }
        hashMap = new HashMap<String, String>();
        hashMap.put("wlanId", wlanGroup.getWlanId());
        return new OperationResponse(ResErrorCode.a, "Save wlan group successfully.", hashMap);
    }

    @Override
    public OperationResponse addWlanGroup(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        WlanGroupModel wlanGroupModel = (WlanGroupModel)JSONObject.toBean((JSONObject)jSONObject, WlanGroupModel.class);
        OperationResponse operationResponse = this.a(wlanGroupModel);
        if (operationResponse.success()) {
            operationResponse.setMsg("Add WLAN Group successfully.");
        }
        return operationResponse;
    }

    @Override
    public OperationResponse modifyWlanGroup(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        WlanGroupModel wlanGroupModel = (WlanGroupModel)JSONObject.toBean((JSONObject)jSONObject, WlanGroupModel.class);
        OperationResponse operationResponse = this.a(wlanGroupModel);
        if (operationResponse.success()) {
            operationResponse.setMsg("Modify WLAN Group successfully.");
        }
        return operationResponse;
    }

    private OperationResponse a(WlanGroupModel wlanGroupModel) {
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)wlanGroupModel);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        WlanGroup wlanGroup = new WlanGroup();
        String string = wlanGroupModel.getBand();
        if (string == null) {
            a.warn("Invalid request, band is null");
            return com.tp_link.eap.util.e.aZ;
        }
        wlanGroup.setWlanId(wlanGroupModel.getWlanId());
        wlanGroup.setRadioId(Integer.valueOf(string.equalsIgnoreCase("2.4GHz") ? 0 : 1));
        wlanGroup.setName(wlanGroupModel.getName());
        return this.saveWlanGroup(wlanGroup, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, String string2) {
        Object object;
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"wlanId").is((Object)string));
        Update update = new Update();
        update.set("wlanName", (Object)string2);
        Object object2 = object = com.tp_link.eap.b.b.a.g((String)"guestglobal");
        synchronized (object2) {
            this.g.updateMulti(query, update, Guest.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, String string2, Integer n2) {
        List<Ap> list = this.d.getApWithWlanGroup(string, n2);
        if (!CollectionUtils.isEmpty(list)) {
            block7: for (Ap ap : list) {
                Object object;
                Object object2 = object = com.tp_link.eap.b.b.a.a((String)ap.getMac());
                synchronized (object2) {
                    Ap ap2 = this.d.getAp(ap.getId());
                    if (ap2 != null) {
                        switch (n2) {
                            case 0: {
                                ap2.setWlan2g(string2);
                                break;
                            }
                            case 1: {
                                ap2.setWlan5g(string2);
                                break;
                            }
                            default: {
                                continue block7;
                            }
                        }
                        this.d.refreshAp(ap2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse deleteWlanGroup(String wlanId, boolean sendMsg) {
        if (null == wlanId) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.r);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            Ssid ssid;
            Object object2;
            Object object3;
            if (!this.h.siteNameAlreadyExist(string)) {
                a.warn("Invalid site name.");
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            WlanGroup wlanGroup = this.b.findByWlanId(wlanId);
            if (null == wlanGroup) {
                return new OperationResponse(ResErrorCode.d);
            }
            if (wlanGroup.getIsDefault() != null && wlanGroup.getIsDefault().booleanValue()) {
                a.warn("Default wlan group can't be deleted.");
                return new OperationResponse(ResErrorCode.x);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (sendMsg && !CollectionUtils.isEmpty((Collection)(object3 = this.c.getSsidsByRadioIdAndWlanId(wlanGroup.getRadioId(), wlanGroup.getWlanId())))) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    ssid = (Ssid)object2.next();
                    arrayList.add(ssid.getId());
                }
            }
            object3 = this.getDefWlanByRadioId(wlanGroup.getRadioId());
            object2 = new ArrayList();
            if (sendMsg && !CollectionUtils.isEmpty((Collection)(ssid = this.c.getSsidsByRadioIdAndWlanId(object3.getRadioId(), object3.getWlanId())))) {
                for (Ap ap : ssid) {
                    object2.add(ap.getId());
                }
            }
            ssid = this.d.getSiteAndWlanAdoptedAps(com.tp_link.eap.d.b.a(), wlanId);
            if (sendMsg) {
                this.a((List<Ap>)ssid, wlanGroup.getRadioId(), arrayList, (List<String>)object2);
            }
            for (Ap ap : ssid) {
                this.d.setWlanGroup(ap.getId(), wlanGroup.getRadioId(), object3.getWlanId(), false);
            }
            this.c.deleteBySiteAndWlan(wlanId);
            this.b.delete(wlanGroup);
        }
        object = new OperationResponse(ResErrorCode.a);
        object.setMsg("Delete wlan group successfully.");
        return object;
    }

    @Override
    public OperationResponse deleteWlanGroup(ControlType type, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("wlanId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            a.warn("Invalid request, wlanId is null");
            return com.tp_link.eap.util.e.aZ;
        }
        return this.deleteWlanGroup(string, true);
    }

    private void a(List<Ap> list, Integer n2, List<String> list2, List<String> list3) {
        SsidConfig ssidConfig;
        ArrayList<SsidC> arrayList;
        List list4;
        if (CollectionUtils.isEmpty(list) || n2 == null) {
            return;
        }
        SsidConfig ssidConfig2 = this.e.a(2, n2, list2);
        SsidConfig ssidConfig3 = this.e.a(1, n2, list3);
        if (ssidConfig2 != null && !CollectionUtils.isEmpty((Collection)(list4 = ssidConfig2.getSsid()))) {
            for (SsidC ssidC : list4) {
                arrayList = new ArrayList<SsidC>();
                arrayList.add(ssidC);
                ssidConfig = this.e.a(2, n2, list2);
                ssidConfig.setSsid(arrayList);
                this.f.refreshRecord(n2 == 0 ? "ssid_2G" : "ssid_5G", ssidConfig, list);
            }
        }
        if (ssidConfig3 != null && !CollectionUtils.isEmpty((Collection)(list4 = ssidConfig3.getSsid()))) {
            for (SsidC ssidC : list4) {
                arrayList = new ArrayList();
                arrayList.add(ssidC);
                ssidConfig = this.e.a(1, n2, list3);
                ssidConfig.setSsid(arrayList);
                this.f.refreshRecord(n2 == 0 ? "ssid_2G" : "ssid_5G", ssidConfig, list);
            }
        }
    }

    @Override
    public OperationResult deleteBySite() {
        String string = com.tp_link.eap.d.b.a();
        List<WlanGroup> list = this.b.findBySiteAndRadioIdOrderByIdAsc(string, 0);
        if (!CollectionUtils.isEmpty(list)) {
            this.b.delete(list);
        }
        if (!CollectionUtils.isEmpty(list = this.b.findBySiteAndRadioIdOrderByIdAsc(string, 1))) {
            this.b.delete(list);
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public List<WlanGroup> getAllBySite() {
        return this.b.findBySiteOrderByIdAsc(com.tp_link.eap.d.b.a());
    }

    @Override
    public WlanGroup getByWlanId(String id) {
        return this.b.findByWlanId(id);
    }

    @Override
    public WlanGroup getBySiteAndRadioIdAndName(String site, Integer radioId, String name) {
        return this.b.findBySiteAndRadioIdAndName(site, radioId, name);
    }

    @Override
    public OperationResponse getWlanGroup(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("wlanId", null);
        if (null == string) {
            return com.tp_link.eap.util.e.aZ;
        }
        return new OperationResponse(ResErrorCode.a, (Object)this.getWlanGroup(string));
    }

    @Override
    public OperationResponse checkWlanGroupOverLimit(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        int n2 = jSONObject.optInt("radioId");
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("data", this.b.countByRadioId(n2) >= 500L);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }
}

